/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.rep.client;

import com.ibm.hsc.rep.serialization.RSerializableInterface;
import com.ibm.hsc.rep.serialization.RSerializableObject;
import com.ibm.hsc.rep.serialization.RSerializableProperty;
import java.io.ObjectStreamException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMValue;

public class RClientObjectId
implements RSerializableInterface {
    private String mNameSpace;
    private String mClassName;
    private Hashtable mKeyHash = new Hashtable();

    public RClientObjectId() {
    }

    public RClientObjectId(String string, String string2) {
        this.mNameSpace = string;
        this.mClassName = string2;
    }

    public void loadObject(RSerializableObject rSerializableObject) throws ObjectStreamException {
        Vector vector = (Vector)rSerializableObject.getObject();
        int n = vector.size();
        this.mNameSpace = (String)vector.elementAt(0);
        this.mClassName = (String)vector.elementAt(1);
        for (int i = 2; i < n; ++i) {
            RSerializableProperty rSerializableProperty = (RSerializableProperty)vector.elementAt(i);
            this.mKeyHash.put(rSerializableProperty.getName(), rSerializableProperty.getRValue());
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        Object object;
        String string = "com.ibm.hsc.rep.RObjectId";
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNameSpace);
        vector.add(this.mClassName);
        Enumeration enumeration = this.mKeyHash.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            Object v = this.mKeyHash.get(object);
            RSerializableProperty rSerializableProperty = new RSerializableProperty(true, (String)object, v);
            vector.add(rSerializableProperty);
        }
        object = new RSerializableObject(string, null, vector);
        return object;
    }

    public String getNameSpace() {
        return this.mNameSpace;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.mClassName);
        stringBuffer.append(".");
        Enumeration enumeration = this.mKeyHash.keys();
        for (int i = 0; i < this.mKeyHash.size(); ++i) {
            String string = (String)enumeration.nextElement();
            Object v = this.mKeyHash.get(string);
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(v);
            if (i >= this.mKeyHash.size() - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public Object getKey(String string) {
        return this.mKeyHash.get(string);
    }

    public Object setKey(String string, Object object) {
        return this.mKeyHash.put(string, object);
    }

    public CIMObjectPath getCIMObjectPath() throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath(this.mClassName, this.mNameSpace);
        Enumeration enumeration = this.mKeyHash.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.mKeyHash.get(string);
            cIMObjectPath.addKey(string, new CIMValue(v));
        }
        return cIMObjectPath;
    }
}

